set sql_safe_updates=0;

SET @sgAppointmentDT=(SELECT id FROM dtprovider WHERE `dataProviderName`='SUBMIT_APPLICATION_PAY_LATER_BUZZ_RECIPIENT');
UPDATE `sql_dtprovider` 
SET 
    `sqlQuery` = "SELECT 
    T1.id AS ID,
    T4.`firstName` AS FIRST_NAME,
    T4.`lastName` AS LAST_NAME,
    T4.`emailId` AS EMAIL_ID,
    T4.`mobileNumber` AS MOBILE_NO,
    T3.`code` AS APPLICATION_CODE,
    T8.displayName AS ACADEMY_NAME_LOCATION,
    T8.academyName AS ACADEMY_NAME,
    (CASE
        WHEN
            T8.logoUrl IS NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl,
                    '/',
                    'emailer/images/logo_default_image.png')
        WHEN
            T8.logoUrl IS NULL
                AND org.orgUrl IS NULL
        THEN
            'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
        ELSE CONCAT(org.orgUrl, '/', T8.logoUrl)
    END) AS LOGO_URL,
    (CASE
        WHEN
            T8.headerUrl IS NOT NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl, '/', T8.headerUrl)
        ELSE NULL
    END) AS HEADER_URL,
    (Case 
        when 
            T8.footerUrl is not null 
                and org.orgUrl IS NOT NULL 
        then 
            CONCAT(org.orgUrl, '/', T8.footerUrl)
        else NULL 
    end) as FOOTER_URL
FROM
    external_users T1
        LEFT JOIN
    external_user_association T2 ON T2.externalUserId = T1.id
        LEFT JOIN
    application T3 ON T3.id = T2.applicationId
        LEFT JOIN
    applicant_person T4 ON T4.id = T3.applicantPersonId
        LEFT OUTER JOIN
    application_program T7 ON T7.applicationId = T3.id
        LEFT OUTER JOIN
    academy_location T8 ON T8.id = T7.academyLocationId
        LEFT OUTER JOIN
    organizations org ON org.id = (SELECT 
            MAX(id)
        FROM
            organizations)
WHERE
    T1.id IN (namedParams)",`jsonString` = '{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 2,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 1
        },
        {
            "id": 3,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 2
        },
        {
            "id": 4,
            "value": "emailId",
            "resultKey": "EMAIL_ID",
            "displayCode": "",
            "displayOrder": 3
        },
        {
            "id": 5,
            "value": "mobileNumber",
            "resultKey": "MOBILE_NO",
            "displayCode": "",
            "displayOrder": 4
        },
        {
            "id": 6,
            "value": "applicationCode",
            "resultKey": "APPLICATION_CODE",
            "displayCode": "",
            "displayOrder": 5
        },
        {
            "id": 7,
            "value": "logoUrl",
            "resultKey": "LOGO_URL",
            "displayCode": "",
            "displayOrder": 6
        },
        {
            "id": 8,
            "value": "headerUrl",
            "resultKey": "HEADER_URL",
            "displayCode": "",
            "displayOrder": 7
        },
        {
            "id": 9,
            "value": "displayName",
            "resultKey": "ACADEMY_NAME_LOCATION",
            "displayCode": "",
            "displayOrder": 8
        },
        {
            "id": 10,
            "value": "academyName",
            "resultKey": "ACADEMY_NAME",
            "displayCode": "",
            "displayOrder": 9
        },
        {
            "id": 11,
            "value": "headerUrl",
            "resultKey": "HEADER_URL",
            "displayCode": "",
            "displayOrder": 10
        },
        {
            "id": 12,
            "value": "footerUrl",
            "resultKey": "FOOTER_URL",
            "displayCode": "",
            "displayOrder": 11
        }
    ]
}' WHERE `dataProviderId` = @sgAppointmentDT;


SET @msgtemplateconfigId=(select id from `msg_template_config` where `code` = 'Submit Application Pay Later Buzz');

UPDATE `msg_template` 
SET `msgContent`= '<html>
<head>
    <title></title>
</head>
<body>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
    <tbody>
        <tr style="background-color:#f0f0f0; height:120px;">
            <td align="center" style="margin:0px;"><img height="120" src="$recipientData[&quot;HEADER_URL&quot;]" width="100%" /></td>
        </tr>
        <tr style="background-color:#f0f0f0; line-height:20px;">
            <td style="padding:20px 20px 20px 20px;">
            <p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><strong>$recipientData[&quot;APPLICATION_CODE&quot;]</strong></p>

            <p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Dear <strong>$recipientData[&quot;FIRST_NAME&quot;] $recipientData[&quot;LAST_NAME&quot;]</strong></span></span></p>

            <p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">Thank you &ndash; we have received your application. Your Application Pending ID is $recipientData[&quot;APPLICATION_CODE&quot;]. Please remember to pay your application fee in order for your application to be processed. Please ignore if you have already paid.</p>

            <p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><br />
            Kind regards,<br />
            <strong>$recipientData[&quot;ACADEMY_NAME_LOCATION&quot;]</strong></p>
            </td>
        </tr>
        <tr>
            <td align="right" style="background-color: #f0f0f0; margin:0px; padding:25px"><img height="50" src="$recipientData[&quot;LOGO_URL&quot;]" /></td>
        </tr>
        <tr>
            <td align="center" style="margin:0px; padding:0px;"><img height="80" width="100%" src="$recipientData[&quot;FOOTER_URL&quot;]" /></td>
        </tr>
    </tbody>
</table>
</body>
</html>' where `msgTemplateConfigId` = @msgtemplateconfigId and `msgDeliveryModeId` = '1';

set sql_safe_updates=1;